﻿using UnityEngine;
using System.Collections;
using GamepadInput;
public enum controlType : int { WASD = 0, ARROWS = 1, GAMEPAD1 = 2, GAMEPAD2 = 3, GAMEPAD3 = 4, GAMEPAD4 = 5 }

public class PlayerInputMapping : MonoBehaviour
{

  private enum Keys : int { Left = 0, Right, Up, Down, Jump, Dash, Shoot };

  KeyCode[] keyCodes = new KeyCode[Keys.GetNames(typeof(Keys)).Length];
  bool usesGamepad;
  GamePad.Index gamepadIndex;


  public void set(controlType controls)
  {
    usesGamepad = true;
    #region switch case controls
    switch (controls)
    {
      case controlType.WASD:
        usesGamepad = false;
        keyCodes[(int)Keys.Right] = KeyCode.D;
        keyCodes[(int)Keys.Left] = KeyCode.A;
        keyCodes[(int)Keys.Up] = KeyCode.W;
        keyCodes[(int)Keys.Jump] = keyCodes[(int)Keys.Up];
        keyCodes[(int)Keys.Down] = KeyCode.S;
        keyCodes[(int)Keys.Dash] = KeyCode.Space;
        keyCodes[(int)Keys.Shoot] = KeyCode.LeftShift;
        break;

      case controlType.ARROWS:
        usesGamepad = false;
        keyCodes[(int)Keys.Right] = KeyCode.RightArrow;
        keyCodes[(int)Keys.Left] = KeyCode.LeftArrow;
        keyCodes[(int)Keys.Up] = KeyCode.UpArrow;
        keyCodes[(int)Keys.Jump] = keyCodes[(int)Keys.Up];
        keyCodes[(int)Keys.Down] = KeyCode.DownArrow;
        keyCodes[(int)Keys.Dash] = KeyCode.RightControl;
        keyCodes[(int)Keys.Shoot] = KeyCode.RightShift;
        break;
      case controlType.GAMEPAD1:
        gamepadIndex = GamePad.Index.One;
        break;
      case controlType.GAMEPAD2:
        gamepadIndex = GamePad.Index.Two;
        break;
      case controlType.GAMEPAD3:
        gamepadIndex = GamePad.Index.Three;
        break;
      case controlType.GAMEPAD4:
        gamepadIndex = GamePad.Index.Four;
        break;
      default:
        break;
    #endregion
    }
  }

  public bool isRightPressed()
  {
    if (usesGamepad)
    {
      Vector2 leftStick = GamePad.GetAxis(GamePad.Axis.LeftStick, gamepadIndex);
      Vector2 dPad = GamePad.GetAxis(GamePad.Axis.Dpad, gamepadIndex);
      return leftStick.x > 0.0f || dPad.x > 0.0f;

    }
    else return Input.GetKey(keyCodes[(int)Keys.Right]);
  }

  public bool isLeftPressed()
  {
    if (usesGamepad)
    {
      Vector2 leftStick = GamePad.GetAxis(GamePad.Axis.LeftStick, gamepadIndex);
      Vector2 dPad = GamePad.GetAxis(GamePad.Axis.Dpad, gamepadIndex);
      return leftStick.x < 0.0f || dPad.x < 0.0f;
    }
    else return Input.GetKey(keyCodes[(int)Keys.Left]);
  }

  public bool isJumpPressed()
  {
    if (usesGamepad) return GamePad.GetButton(GamePad.Button.A, gamepadIndex);
    else return Input.GetKey(keyCodes[(int)Keys.Jump]);
  }

  public bool isUpPressed()
  {
    if (usesGamepad)
    {
      Vector2 leftStick = GamePad.GetAxis(GamePad.Axis.LeftStick, gamepadIndex);
      Vector2 dPad = GamePad.GetAxis(GamePad.Axis.Dpad, gamepadIndex);
      return leftStick.y > 0.0f || dPad.y > 0.0f;
    }
    else return Input.GetKey(keyCodes[(int)Keys.Up]);
  }

  public bool isDownPressed()
  {
    if (usesGamepad)
    {
      Vector2 leftStick = GamePad.GetAxis(GamePad.Axis.LeftStick, gamepadIndex);
      Vector2 dPad = GamePad.GetAxis(GamePad.Axis.Dpad, gamepadIndex);
      return leftStick.y < 0.0f || dPad.y < 0.0f;
    }
    else return Input.GetKey(keyCodes[(int)Keys.Down]);
  }

  public bool isDashPressed()
  {
    if (usesGamepad)
    {
      return (GamePad.GetTrigger(GamePad.Trigger.LeftTrigger, gamepadIndex) > 0.01f) || (GamePad.GetTrigger(GamePad.Trigger.RightTrigger, gamepadIndex) > 0.01f)
          || GamePad.GetButton(GamePad.Button.LeftShoulder, gamepadIndex) || GamePad.GetButton(GamePad.Button.RightShoulder, gamepadIndex);
    }
    else return Input.GetKey(keyCodes[(int)Keys.Dash]);
  }

  public bool isShootPressed()
  {
    if (usesGamepad)
    {
      return GamePad.GetButton(GamePad.Button.X, gamepadIndex) || GamePad.GetButton(GamePad.Button.Y, gamepadIndex);
    }
    else return Input.GetKey(keyCodes[(int)Keys.Shoot]);
  }
}
