﻿using UnityEngine;
using System.Collections;
using UnityEngine.UI;

public class PlayerHealth : MonoBehaviour
{

  public float maxHealth = 100;

  public float currentHealth = 100;
  private bool alive = true;
  private Scrollbar healthbar;
  private PlayerControl playerControl;
  private bool hasShield = false;

  public void init(int playerNumber)
  {
    string healthbarName = "HealthBar" + playerNumber;
    string healthbarParentName = "HealthBarParent" + playerNumber; //wichtig um healthbars von nicht vorhandenen spielern auszublenden
    GameObject healthbarParent = GameObject.Find(healthbarParentName);

    //activate all children, which are disabled by default:
    foreach (Transform child in healthbarParent.transform)
    {
      child.gameObject.SetActive(true);
    }

    healthbar = GameObject.Find(healthbarName).GetComponent<Scrollbar>();

    if (name.EndsWith("(Clone)"))
    {
      name = name.Split(new char[] { '(' })[0];
    }
  }

  // Update is called once per frame
  void Update()
  {
    if (alive && currentHealth <= 0)
    {
      Debug.Log("Player " + name + " dead.");
      alive = false;
      ((GameStateTracker)Object.FindObjectOfType(typeof(GameStateTracker))).playerDied(name);
      healthbar.gameObject.SetActive(false); //hide healthbar
      Destroy(gameObject);
    }
  }

  public float getCurrentHealth()
  {
    return currentHealth;
  }

  //updated die ui healthbar.
  private void updateHealthbar()
  {
    if (healthbar)
    {
      healthbar.size = currentHealth / maxHealth;
    }
  }

  /// <summary>
  /// Erhöht bzw. erniedrigt aktuelle Gesundheit um Wert h, Gesundheit kann nicht höher werden als maxHealth.
  /// </summary>
  /// <param name="h"></param>
  public void changeHealthBy(float h)
  {
    if (hasShield && h < 0) return;

    currentHealth += h;
    if (currentHealth > maxHealth) currentHealth = maxHealth;
    updateHealthbar();
  }

  public void setShield(bool s)
  {
    Debug.Log("Shield " + s + " accepted");
    hasShield = s;
  }
}
