﻿using UnityEngine;
using System.Collections;
using System.Collections.Generic;
using GamepadInput;
using UnityEngine.UI;

public class Menu : MonoBehaviour
{
  public GameStateTracker gameStateTracker;
  public GameObject gameUI;
  public GameMaster gameMaster;
  public GameObject menuPanel;
  public GameObject p1Image, p2Image, p3Image, p4Image;
  public List<PlayerInputMapping> inputMappings;
  private int numberOfRegisteredPlayers;

  private bool WASDAdded, ArrowAdded, GP1Added, GP2Added, GP3Added, GP4Added;

  void Start()
  {
    #region init bools
    WASDAdded = false;
    ArrowAdded = false;
    GP1Added = false;
    GP2Added = false;
    GP3Added = false;
    GP4Added = false;
    #endregion
    numberOfRegisteredPlayers = 0;
    inputMappings = new List<PlayerInputMapping>();
    for (int i = 1; i < 5; i++)
    {
      inputMappings.Add(GameObject.Find("InputMapping" + i).GetComponent<PlayerInputMapping>());
    }
  }

  //returns true if game was started;
  private bool startGameIfPossible(int levelNumber = -1)
  {
    if (numberOfRegisteredPlayers > 1 || (numberOfRegisteredPlayers > 0 && Debug.isDebugBuild))
    {
      gameUI.SetActive(true);
      gameStateTracker.setNumberOfPlayers(numberOfRegisteredPlayers);
      gameStateTracker.reset();
      gameMaster.loadLevel(numberOfRegisteredPlayers, levelNumber);
      gameObject.SetActive(false);
      return true;
    }
    else return false;
  }

  void Update()
  {
    if (Debug.isDebugBuild)
    {
      for (int i = 0; i < 10; i++)
      {
        if (Input.GetKeyDown(i.ToString()))
        {
          startGameIfPossible(i);
        }
      }
    }

    if (Input.GetKeyDown(KeyCode.Space))
    {
      if (WASDAdded)
      {
        if (startGameIfPossible())
        {
          return;
        }
      }
      else
      {
        int playerNumber = addPlayer();
        if (playerNumber > 0)
        {
          inputMappings[playerNumber - 1].set(controlType.WASD);
          WASDAdded = true;
        }
      }
    }
    if (Input.GetKeyDown(KeyCode.RightControl))
    {
      if (ArrowAdded)
      {
        if (startGameIfPossible())
        {
          return;
        }
      }
      else
      {
        int playerNumber = addPlayer();
        if (playerNumber > 0)
        {
          ArrowAdded = true;
          inputMappings[playerNumber - 1].set(controlType.ARROWS);
        }
      }

    }
    if (GamePad.GetButtonDown(GamePad.Button.A, GamePad.Index.One))
    {
      if (GP1Added)
      {
        if (startGameIfPossible())
        {
          return;
        }
      }
      else
      {
        int playerNumber = addPlayer();
        if (playerNumber > 0)
        {
          GP1Added = true;
          inputMappings[playerNumber - 1].set(controlType.GAMEPAD1);
        }
      }

    }
    if (GamePad.GetButtonDown(GamePad.Button.A, GamePad.Index.Two))
    {
      if (GP2Added)
      {
        if (startGameIfPossible())
        {
          return;
        }
      }
      else
      {
        int playerNumber = addPlayer();
        if (playerNumber > 0)
        {
          GP2Added = true;
          inputMappings[playerNumber - 1].set(controlType.GAMEPAD2);
        }
      }

    }
    if (GamePad.GetButtonDown(GamePad.Button.A, GamePad.Index.Three))
    {
      if (GP3Added)
      {
        if (startGameIfPossible())
        {
          return;
        }
      }
      else
      {
        int playerNumber = addPlayer();
        if (playerNumber > 0)
        {
          GP3Added = true;
          inputMappings[playerNumber - 1].set(controlType.GAMEPAD3);
        }
      }
    }
    if (GamePad.GetButtonDown(GamePad.Button.A, GamePad.Index.Four))
    {
      if (GP4Added)
      {
        if (startGameIfPossible())
        {
          return;
        }
      }
      else
      {
        int playerNumber = addPlayer();
        if (playerNumber > 0)
        {
          GP4Added = true;
          inputMappings[playerNumber - 1].set(controlType.GAMEPAD4);
        }
      }
    }
  }

  //returns the player number (3 for player three). returns -1 when there is no free player slot.
  private int addPlayer()
  {
    if (!p1Image.activeSelf)
    {
      p1Image.SetActive(true);
      numberOfRegisteredPlayers = 1;
      return 1;
    }
    else if (!p2Image.activeSelf)
    {
      p2Image.SetActive(true);
      numberOfRegisteredPlayers = 2;
      return 2;
    }
    else if (!p3Image.activeSelf)
    {
      p3Image.SetActive(true);
      numberOfRegisteredPlayers = 3;
      return 3;
    }
    else if (!p4Image.activeSelf)
    {
      p4Image.SetActive(true);
      numberOfRegisteredPlayers = 4;
      return 4;
    }
    else return -1;
  }
}
