using UnityEngine;
using System.Collections;
using System.Xml;

public class DeserializedLevelsSaver
{
  public const string xmlItemsToExportGOName = "XmlItemsToExport";

  public void saveExportItems()
  {

    // Create XmlItemsToExport if does not exist yet
    if (GameObject.Find(xmlItemsToExportGOName) == null)
      new GameObject(xmlItemsToExportGOName);

    GameObject xmlItemsToExportGO = GameObject.Find(xmlItemsToExportGOName);
    var xmlItemsToExportGOchildren = xmlItemsToExportGO.GetComponentsInChildren<Transform>();

    // Check if any children exist
    if (xmlItemsToExportGOchildren.Length == 0)
      Debug.LogError("Add the prefabs to " + xmlItemsToExportGOName);

    DeserializedLevels.Level levelXml = new DeserializedLevels.Level();

    int n = 0;
    // count number of children skipping sub-items
    foreach (Transform item in xmlItemsToExportGOchildren)
      if (item.parent == xmlItemsToExportGO.transform) n++;

    // the items array should have that many elements
    levelXml.items = new DeserializedLevels.Item[n];

    // use i for counting items, i would be equal (one more to be precise) to n at the end of the cycle
    int i = 0;

    // cycle through the children again and add them to items
    foreach (Transform item in xmlItemsToExportGOchildren)
    {
      // skip sub-items
      if (item.parent != xmlItemsToExportGO.transform) continue;

      levelXml.items[i] = new DeserializedLevels.Item();

      string name = item.name;
      name = name.Replace("(Clone)", "");
      levelXml.items[i].prefab = item.name;
      levelXml.items[i].x = toStringNullIfZero(item.transform.position.x);
      levelXml.items[i].y = toStringNullIfZero(item.transform.position.y);
      levelXml.items[i].rot = toStringNullIfZero(item.localRotation.eulerAngles.z);
      levelXml.items[i].scalex = toStringNullIfOne(item.localScale.x);
      levelXml.items[i].scaley = toStringNullIfOne(item.localScale.y);

      DeserializedLevels.Item[] children = new DeserializedLevels.Item[item.childCount];
      Debug.Log("Child count for " + item.name + ": " + item.childCount);
      int k = 0;
      foreach (Transform t in item.GetComponentsInChildren<Transform>())
      {
        if (!t.parent.name.Equals("XmlItemsToExport"))
        {
          //GetComponentsInChildren gibt auch die Komponente aus dem Parent (also dem Objekt selbst) zurck
          DeserializedLevels.Item child = new DeserializedLevels.Item();

          Debug.Log("Add child " + t.name);
          child.prefab = t.name;
          child.x = toStringNullIfZero(t.position.x);
          child.y = toStringNullIfZero(t.position.y);
          child.rot = toStringNullIfZero(t.rotation.eulerAngles.z);
          child.scalex = toStringNullIfOne(t.localScale.x);
          child.scaley = toStringNullIfOne(t.localScale.y);

          children[k] = child;

          k++;
        }
      }

      levelXml.items[i].children = (item.childCount > 0) ? children : null;

      i++;
    }


    // Export just one level
    DeserializedLevels levelsXmlToExport = new DeserializedLevels();
    levelsXmlToExport.levels = new DeserializedLevels.Level[1];
    levelsXmlToExport.levels[0] = levelXml;
    XmlIO.SaveXml<DeserializedLevels>(levelsXmlToExport, "./Assets/Resources/" + xmlItemsToExportGOName + ".xml");
  }

  string toStringNullIfZero(float num) { return num == 0 ? null : mathRound(num, 2).ToString(); }
  string toStringNullIfOne(float num) { return num == 1 ? null : mathRound(num, 2).ToString(); }


  float mathRound(float round, int decimals)
  {
    return Mathf.Round(round * Mathf.Pow(10, decimals)) / Mathf.Pow(10, decimals);
  }
}
