﻿using UnityEngine;
using System.Collections;
using System.Collections.Generic;

public class GameStateTracker : MonoBehaviour
{


  private int numberOfPlayers;
  /// <summary>
  /// Numbers of Player ranked 4th to winner
  /// </summary>
  private int fourthPlayer;
  private int thirdPlayer;
  private int secondPlayer;
  private int winnerPlayer;

  private List<string> ranking;
  private GameMaster gameMaster;


  void Awake()
  {
    ranking = new List<string>();
  }

  // Use this for initialization
  void Start()
  {
    gameMaster = GetComponent<GameMaster>();
  }

  public void reset()
  {
    ranking.Clear();
  }

  public void setNumberOfPlayers(int players)
  {
    numberOfPlayers = players;
  }

  public void playerDied(string name)
  {
    if (!ranking.Contains(name))
    {
      ranking.Add(name);
    }
    if (ranking.Count >= numberOfPlayers - 1)
    {
      gameOver();
    }
  }

  public void gameOver()
  {
    Time.timeScale = 0.0f; //stops the game

    //find the player who is still alive:
    string playerStillAlive = "";
    GameObject[] players = GameObject.FindGameObjectsWithTag("Player");
    foreach (GameObject p in players)
    {
      if (p.GetComponent<PlayerHealth>().getCurrentHealth() > 0)
      {
        playerStillAlive = p.name;
        ranking.Add(playerStillAlive);
        break;
      }
    }

    gameMaster.gameOver(ranking); //shows the game over screen
  }

}
