﻿using UnityEngine;
using System.Collections;
using System.Collections.Generic;
using UnityEngine.UI;

public class GameMaster : MonoBehaviour
{

  DeserializedLevelsLoader levelLoader;
  public PlayerControl[] playerPrefabs;
  public GameObject gameOverPanel;
  public Text rankingText;

  // Use this for initialization
  void Start()
  {
    levelLoader = new DeserializedLevelsLoader();
    levelLoader.load();
  }

  public void loadLevel(int numberOfPlayers, int level = -1)
  {
    if (level < 0)
      level = Random.Range(0, levelLoader.getLevelCount());
    levelLoader.loadLevel(level);

    deleteAllPlayers();
    spawnPlayers(numberOfPlayers);
  }


  private void deleteAllPlayers()
  {
    foreach (GameObject player in GameObject.FindGameObjectsWithTag("Player"))
      Object.Destroy(player, 0f);
  }

  private void spawnPlayers(int count)
  {
    Debug.Log("spawning " + count + " players");

    GameObject[] startPositions = GameObject.FindGameObjectsWithTag("Start_Position");
    if (count > startPositions.Length)
    {
      count = startPositions.Length;
      Debug.LogError("map is capped at " + count + " players");
    }

    shuffle(startPositions);

    for (int i = 0; i < count; i++)
    {
      PlayerControl player = (PlayerControl)Object.Instantiate(
          playerPrefabs[i % playerPrefabs.Length],
          startPositions[i].transform.position,
          Quaternion.identity);
      player.init(i + 1);
    }
  }

  private static void shuffle<T>(T[] array)
  {
    int i = array.Length;
    while (i > 1)
    {
      int k = Random.Range(0, i--);
      T t = array[k];
      array[k] = array[i];
      array[i] = t;
    }
  }

  public void gameOver(List<string> ranking)
  {
    gameOverPanel.SetActive(true);

    Debug.Log(ranking.Count);
    if (ranking.Count > 0)
    {
      rankingText.text = "1st: " + ranking[0];
    }
    if (ranking.Count > 1)
    {
      rankingText.text += "\n2nd: " + ranking[1];
    }
    if (ranking.Count > 2)
    {
      rankingText.text += "\n3rd: " + ranking[2];
    }
    if (ranking.Count > 3)
    {
      rankingText.text += "\n4th: " + ranking[3];
    }
  }
}
