﻿using UnityEngine;
using System.Collections;

public class FireScript : MonoBehaviour
{

  PlayerHealth parentHealth;

  public float constantDamagepoints = 0.1f;

  public float burningTime = 10f;

  private Vector3 startScale; //fixes a bug: scale of fire was 0 when attached to the player.


  void Start()
  {
    startScale = transform.localScale;
  }

  // Update is called once per frame
  void Update()
  {
    if (parentHealth)
    {
      parentHealth.changeHealthBy(-constantDamagepoints * Time.deltaTime);
    }
  }

  void OnTriggerEnter2D(Collider2D other)
  {
    if (other.tag == "Player")
    {
      parentHealth = other.GetComponent<PlayerHealth>();
      transform.position = other.transform.position; //hier schon position setzen
      transform.parent = other.transform;
      transform.localScale = startScale;
      Invoke("stopBurning", burningTime);
    }
  }

  void stopBurning()
  {
    Destroy(gameObject);
  }
}
