﻿using UnityEngine;
using System.Collections;

public class Bullet : MonoBehaviour
{

  public int healingPoints = 10;
  public bool destroyTrap = false;
  public int speed = 5;


  /// <summary>
  /// Das aufrufen, wenn die Kugel wirklich losgeschossen werden soll.
  /// </summary>
  /// <param name="direction"></param>
  public void shoot(Vector2 direction)
  {
    GetComponent<Rigidbody2D>().velocity = (float)speed * direction.normalized;
  }

  void OnTriggerEnter2D(Collider2D other)
  {
    //Debug.Log("Bullet colide with " + other.name);
    if (healingPoints > 0 && other.tag == "Player")
    {
      other.GetComponent<PlayerHealth>().changeHealthBy(healingPoints);
      Destroy(gameObject);
    }
    else if (destroyTrap && other.tag == "Trap")
    {
      other.GetComponent<Trap>().destroyTrap();
      Destroy(gameObject);
    }
  }

}
