#include "scenegraph.h"
#include "myglwidget.h"

SceneGraph::SceneGraph()
{
    nodes = QList<RigidBodyTransformation*>();
    views = QList<MyGLWidget*>();
    idCounter = 0;
    sphereIndex = 1;
    boxIndex = 1;
    cylIndex = 1;
    coneIndex = 1;
    torusIndex = 1;

}

//Scenegraph gets a list of all views it needs to notify on changes
void SceneGraph::registerView(MyGLWidget* view){
    views.append(view);
}

//add primitives to sceneGraph
RigidBodyTransformation* SceneGraph::addSphere(int tesselation){
    nextSphereName = "Sphere " + sphereIndex;
    //tesselation < 3 makes no sense.
    Primitive* p = new Primitive(idCounter, nextSphereName, tesselation+2, Primitive::Type::SPHERE);
    idCounter++;
    sphereIndex++;

    qDebug() << "New Sphere added in scenegraph." << nextSphereName;

    return addPrimitive(p);
}

RigidBodyTransformation* SceneGraph::addBox(int tesselation){

    nextBoxName = "Box " + boxIndex;
    Primitive* p = new Primitive(idCounter, nextBoxName, tesselation, Primitive::Type::BOX);
    idCounter++;
    boxIndex++;

    qDebug("New box added in scenegraph");

    return addPrimitive(p);
}

RigidBodyTransformation* SceneGraph::addCylinder(int tesselation){
    qDebug("TODO add cylinder to scenegraph");
    return addBox(1);
}

RigidBodyTransformation* SceneGraph::addCone(int tesselation){
    qDebug("TODO add cone to scenegraph");
    return addBox(tesselation);
}

RigidBodyTransformation* SceneGraph::addTorus(int tesselation){
    qDebug("TODO add torus to scenegraph");
    return addBox(1);
}

RigidBodyTransformation* SceneGraph::addPrimitive(Primitive* p){
    RigidBodyTransformation* r = new RigidBodyTransformation(p);
    nodes.append(r);
    notifyViews();
    return r;
}

//transform something
void SceneGraph::addRotation(RigidBodyTransformation *r, QQuaternion diff){
    r->addRotation(diff);
    notifyViews();
}

void SceneGraph::addTranslation(RigidBodyTransformation *r, QVector3D diff){
    r->addTranslation(diff);
    notifyViews();
}

//for drawing
const QList<RigidBodyTransformation*> SceneGraph::getGraph(){
    return nodes;
}

//notifies views whenever something changes (is added or transformed)
void SceneGraph::notifyViews(){
    QList<MyGLWidget*>::iterator i;
    for (i = views.begin(); i != views.end(); i++){
        (*i)->modelChanged();
    }
}
