#include "rigidbodytransformation.h"

RigidBodyTransformation::RigidBodyTransformation(Primitive* child)
{
    translation = QVector3D(0,0,0);
    rotation = QQuaternion();
    this->child = child;
//    qDebug() << "new rbt " << tx << "," << ty << "," << tz << ", rot " << rotation;
}


void RigidBodyTransformation::addTranslation(QVector3D diff){
    translation += diff;
}

const QVector3D RigidBodyTransformation::getTranslation(){
    return translation;
}

const QQuaternion RigidBodyTransformation::getRotation(){
    return rotation;
}

void RigidBodyTransformation::addRotation(QQuaternion diff){
    rotation = diff*rotation;
    rotation.normalize();
}

void RigidBodyTransformation::setRotation(QQuaternion newRotation){
    rotation = newRotation;
}

Primitive* RigidBodyTransformation::getChild(){
    return child;
}
