#ifndef GLWIDGET_H
#define GLWIDGET_H

#include <QGLWidget>
#include <gl/GLU.h>
#include <QDebug>
#include <QWheelEvent>
#include <QQuaternion>
#include <QMatrix4x4>
#include <math.h>
#include <QVector3D>
#include <QGLShaderProgram>
#include <QGLShader>
#include <QStyleOption>
#include <QStylePainter>

#include <rigidbodytransformation.h>//vorläufig, bis szenengraph steht.

class Controller;
class SceneGraph;

class MyGLWidget : public QGLWidget
{
    Q_OBJECT //from HelloGL Example

   public:
    //Pass initial camera rotation and isPerspective = false for fixed views
       MyGLWidget(int index, Controller* c, bool isPerspective, QQuaternion initalRotation, QWidget *parent = 0);
       ~MyGLWidget();

       //From HelloGL example.
       QSize minimumSizeHint() const;
       QSize sizeHint() const;


       /* Assignment 2*/
       bool modeCamera;
       void translateCamera(double xDiff, double yDiff, double zDiff = 0);
       void rotateCamera(QQuaternion diff);
        QQuaternion getCameraRotation();

       void initShaderStuff();

       int getIndex();
       void setFocused(bool isFocused);//Tell view if it is focused and therefore needs a yellow border

       void modelChanged();
protected:
       //4.1 Core Functionality
    void initializeGL();
    void paintGL();
    void resizeGL(int width, int height);
    void mousePressEvent(QMouseEvent *event);
    void mouseMoveEvent(QMouseEvent *event);
    void wheelEvent(QWheelEvent *event);
    void keyPressEvent(QKeyEvent * event);//for ctrl key for mode switch
    void keyReleaseEvent(QKeyEvent *event);//for ctrl key for mode switch

    Controller* controller;

private:
    int index;//hardcoding ftw. for easier access in controller. 0 = perspective, 1 = front, 2 = left, 3 = top

    //tesselation slider
    int tesselation;
    bool isPerspective;

    //zoom camera
    const double cameraZoomDefault = -5;
    double cameraZoom;
    QQuaternion cameraRotation;
    QQuaternion cameraStartRotation;
    QVector3D camRotCenter;

    //Phong Shader
    QGLShaderProgram *phongShader;

    Primitive* primitive;
    char* platzhalter;


    void highlightViewport();
    void resetProjectionMatrix();
    double windowWidth, windowHeight;
    bool isFocused;

    SceneGraph* scene;

    void drawSphere(int tesselation);
    void drawBox(int tesselation);
    void drawCylinder(int tesselation);
    void drawCone(int tesselation);
    void drawTorus(int tesselation);
public slots:
    //4.1.1 slots for shading modes
    void shadeWireframeSlot();
    void shadeFlatSlot();
    void shadeGouraudSlot();
    void shadePhongSlot();
    void resetCamera();
};

#endif // GLWIDGET_H
