#ifndef CONTROLLER_H
#define CONTROLLER_H
#include <QGLWidget>
#include <gl/GLU.h>
#include <QDebug>
#include <QWheelEvent>
#include <QQuaternion>
#include <QMatrix4x4>
#include <math.h>
#include <QVector3D>
#include <QGLShaderProgram>
#include <QGLShader>
#include <QDebug>
#include <QObject>
#include <QAction>
#include <QQuaternion>
#include <QGridLayout>
#include <rigidbodytransformation.h>

class MyGLWidget;
class SceneGraph;

class Controller : public QObject
{
    Q_OBJECT

public:
    Controller();
    ~Controller();

    void initActions(QAction* cam, QAction* manipulate);
    void initViewWidgets(MyGLWidget* views[4], QWidget* doubleViews, QWidget* quadViews, QGridLayout* layout);

    //processes input and might call follow up functions in widget
    void processMousePressEvent(QMouseEvent* event, MyGLWidget* widget);

    //processes mouse movement, calls some translate / rotate function in widget
    void processMouseMoveEvent(QMouseEvent* event, MyGLWidget* widget);

    void setScreenScenter(QPoint center);

    void setCtrlPressed(bool isCtrlPressed);

    SceneGraph* getSceneGraph();

    RigidBodyTransformation* currentTransform;
private:
    QAction *modeCameraAction;
    QAction *modeManipulateAction;

    int currentWidgetIndex;

    QWidget* quadViewWidget;
    QWidget* doubleViewWidget;
    MyGLWidget* views[4];
    QGridLayout* viewLayout;

    bool modeCamera;

    bool ctrlPressed = false;

    bool rightButtonPressed;
    bool leftButtonPressed;
    QPoint screenCenter;//Center of screen in pixel coordinates
    QPoint lastClickPosition;

    QQuaternion computeRotation(QPoint newPosition);

    int tesselation;

    SceneGraph* scene;

public slots:
    void switchToModeCamera();
    void switchToModeManipulate();
    void resetCamera();

    void showSingleView();
    void showDoubleView();
    void showQuadView();

    void setTessellation(int t);

    void addSphere();
    void addBox();
    void addCylinder();
    void addCone();
    void addTorus();

};

#endif // CONTROLLER_H
