#include "controller.h"
#include "myglwidget.h"
#include "scenegraph.h"

Controller::Controller()
{
    modeCamera = true;
    currentWidgetIndex = 0;
    scene = new SceneGraph();
    currentTransform = 0;
    tesselation = 1;
}

Controller::~Controller(){

}

SceneGraph* Controller::getSceneGraph(){
    return scene;
}

void Controller::initActions(QAction *cam, QAction *manipulate){
    modeCameraAction = cam;
    modeManipulateAction = manipulate;
}

void Controller::initViewWidgets(MyGLWidget *allViews[4], QWidget *two, QWidget *four, QGridLayout* layout){
    for (int i = 0; i < 4; i++){
        views[i] = allViews[i];//Are you kidding me c++?
    }
    currentWidgetIndex = 0;
    doubleViewWidget = two;
    quadViewWidget = four;
    viewLayout = layout;
}

void Controller::showSingleView(){
    viewLayout = new QGridLayout();
    viewLayout->removeWidget(quadViewWidget);
    viewLayout->removeWidget(doubleViewWidget);
    viewLayout->addWidget(views[0],0,0);
    for (int i = 1; i < 4; i++){
        views[i]->hide();
    }
    views[0]->show();

    views[currentWidgetIndex]->setFocused(false);
    currentWidgetIndex = 0;
    views[currentWidgetIndex]->setFocused(true);

}

void Controller::showDoubleView(){
    viewLayout = new QGridLayout();
    viewLayout->removeWidget(quadViewWidget);
    viewLayout->removeWidget(views[0]);
    viewLayout->addWidget(doubleViewWidget);
    for (int i = 2; i < 4; i++){
        views[i]->hide();
    }
    for (int i = 0; i < 2; i++){
        views[i]->show();
    }
    if (currentWidgetIndex > 1) {
        views[currentWidgetIndex]->setFocused(false);
        currentWidgetIndex = 0;
        views[currentWidgetIndex]->setFocused(true);
    }
}

void Controller::showQuadView(){
    viewLayout = new QGridLayout();
    viewLayout->removeWidget(doubleViewWidget);
    viewLayout->removeWidget(views[0]);
    viewLayout->addWidget(quadViewWidget);
    for (int i = 0; i < 4; i++){
        views[i]->show();
    }
}


void Controller::setTessellation(int t){
    qDebug() << "Tesselation: " << t;
    tesselation = t;
}


void Controller::setCtrlPressed(bool isCtrlPressed){
    ctrlPressed = isCtrlPressed;
}

void Controller::switchToModeCamera(){
    qDebug("Bla");
    modeCamera = true;
}

void Controller::switchToModeManipulate(){
    modeCamera = false;
}

void Controller::processMousePressEvent(QMouseEvent *event, MyGLWidget *widget){
    rightButtonPressed = false;
    leftButtonPressed = false;
    if (ctrlPressed){
     if (modeCamera){
         modeCamera = false;
         modeCameraAction->setChecked(false);
         modeManipulateAction->setChecked(true);
     }   else{
         modeCamera = true;
         modeCameraAction->setChecked(true);
         modeManipulateAction->setChecked(false);
     }
    }
    if (event->button() == Qt::RightButton){
        rightButtonPressed = true;
        lastClickPosition = event->pos();
        qDebug() << "mouse press at " << lastClickPosition;
    } else if (event->button() == Qt::LeftButton){
        leftButtonPressed = true;
        lastClickPosition = event->pos();
    }
    if (currentWidgetIndex != widget->getIndex()){
        qDebug("Mouse Press event with other index");
        views[currentWidgetIndex]->setFocused(false);
        currentWidgetIndex = widget->getIndex();
        views[currentWidgetIndex]->setFocused(true);
    }
}

void Controller::processMouseMoveEvent(QMouseEvent *event, MyGLWidget *widget){
    //This didn't work properly, used bool to store state instead. if (event->button() == Qt::RightButton){
    if (rightButtonPressed){
        QPoint currentPosition = event->pos();
        QPoint diff = currentPosition - lastClickPosition;
        lastClickPosition = currentPosition;
        if (modeCamera){
            //view change
            widget->translateCamera(-0.01*diff.x(),0.01*diff.y());
        } else if (currentTransform){
            qDebug("CurrentTransform not null");
            //state change for model
            QVector3D diffV(0.01*diff.x(),-0.01*diff.y(),0);
            diffV = widget->getCameraRotation().conjugate().rotatedVector(diffV);
            scene->addTranslation(currentTransform,diffV);
        }
    }else if (leftButtonPressed){
        QQuaternion q = computeRotation(event->pos());
        if (modeCamera){
            //guess this counts as view selection...
            widget->rotateCamera(q);
        }else if (currentTransform){//only if sth is selected
            qDebug("CurrentTransform not null");
            //state change for model
            scene->addRotation(currentTransform,q);
        }
    }
}

void Controller::resetCamera(){
    if (views[currentWidgetIndex]){
        views[currentWidgetIndex]->resetCamera();
    }
}

void Controller::setScreenScenter(QPoint center){
    screenCenter = center;
}

QQuaternion Controller::computeRotation(QPoint newPosition){
    //according to https://www.opengl.org/wiki/Object_Mouse_Trackball

    double radius = std::min(screenCenter.x(),screenCenter.y());

    //translate touches around screen center
    double xOld = ((double)(lastClickPosition.x() - screenCenter.x()));
    double yNew = ((double)(lastClickPosition.y() - screenCenter.y()));

    double xNew = ((double)(newPosition.x() - screenCenter.x()));
    double yOld = ((double)(newPosition.y() - screenCenter.y()));

        lastClickPosition = newPosition;

        //https://www.opengl.org/wiki/Object_Mouse_Trackball#Sit_and_spin

        //compute z coordinates ether on sphere or on hyperbolic sheet
        double zOld, zNew;
        double rsquareover2 = radius*radius/2.0;
        double xyOld = xOld*xOld + yOld*yOld;
        double xyNew = xNew*xNew + yNew*yNew;
        if (xyOld < rsquareover2){
            zOld = sqrt(radius*radius - xyOld);
            qDebug() << "z old 1 " << zOld;
        }else{
            zOld = rsquareover2/(sqrt(xyOld));
            qDebug() << "z old 2 " << zOld;
        }
        if(xyNew < rsquareover2){
            zNew = sqrt(radius*radius - xyNew);
        }else{
            zNew = rsquareover2/sqrt(xyNew);
        }

        // set V_1 and V_2 (Vectors on Sphere around screen center, corresponding to input
        QVector3D v1 = QVector3D(xOld,yOld,zOld);
        v1.normalize();

        QVector3D v2 = QVector3D(xNew,yNew,zNew);
        v2.normalize();

        //Compute normal of plane through v1 and v2 -> rotation axis
        QVector3D n = QVector3D::crossProduct(v1,v2);
        n.normalize();

        //and theta (angle between v1 and v2)
        double theta = acos(QVector3D::dotProduct(v1,v2));

        //Accumulate Rotation
        QQuaternion q = QQuaternion(cos(theta/2.0),sin(theta/2)*n);
        q.normalize();
        qDebug() << "quaternion diff " << q << "xo " << xOld << "yo " << yOld << " x new " << xNew << " ynew " << yNew;
        qDebug() << "v1 " << v1 << ", v2 " << v2;

        return q;
}

void Controller::addSphere(){
    currentTransform = scene->addSphere(tesselation);
}

void Controller::addBox(){
    currentTransform = scene->addBox(tesselation);
}

void Controller::addCylinder(){
currentTransform = scene->addCylinder(tesselation);
}

void Controller::addCone(){
    currentTransform = scene->addCone(tesselation);
}

void Controller::addTorus(){
    currentTransform = scene->addTorus(tesselation);
}
