#ifndef SCENEGRAPH_H
#define SCENEGRAPH_H

#include <QList>
#include <rigidbodytransformation.h>

class MyGLWidget;

class SceneGraph
{
public:
    SceneGraph();

    RigidBodyTransformation* addSphere(int tesselation);
    RigidBodyTransformation* addBox(int tesselation);
    RigidBodyTransformation* addCylinder(int tesselation);
    RigidBodyTransformation* addCone(int tesselation);
    RigidBodyTransformation* addTorus(int tesselation);

    void drawAll();
    void registerView(MyGLWidget* view);
    void notifyViews();

    void addTranslation(RigidBodyTransformation* r, QVector3D diff);
    void addRotation(RigidBodyTransformation* r, QQuaternion diff);

    const QList<RigidBodyTransformation*> getGraph();

//Hallo. Todos:
    //Log selected name in status bar
    //add remaining primitive types
    //extract draw method to something more view-like
    //delete primitives
private:
    int idCounter;

    int sphereIndex;
    int boxIndex;
    int cylIndex;
    int coneIndex;
    int torusIndex;

    QString nextSphereName;
    QString nextBoxName;
    QString nextCylName;
    QString nextConeName;
    QString nextTorusName;

    RigidBodyTransformation* addPrimitive(Primitive* p);

    QList<RigidBodyTransformation*> nodes;
    QList<MyGLWidget*> views;


};

#endif // SCENEGRAPH_H
