#ifndef RIGIDBODYTRANSFORMATION_H
#define RIGIDBODYTRANSFORMATION_H

#include <QQuaternion>
#include <primitive.h>

class RigidBodyTransformation
{
public:
    RigidBodyTransformation(Primitive* child);

    void addTranslation(QVector3D diff);
    void setRotation(QQuaternion newRotation);
    void addRotation(QQuaternion diff);

    const QQuaternion getRotation();
    const QVector3D getTranslation();
    Primitive* getChild();

    void drawChild();

private :
    //translation
    QVector3D translation;
    //rotation
    QQuaternion rotation;

    //child in scene graph
    Primitive* child;
};

#endif // RIGIDBODYTRANSFORMATION_H
