varying vec3 Normal;
varying vec4 Vertex;

uniform gl_MaterialParameters gl_FrontMaterial;

void main(void)
{
/*
//    vec4 white = vec4(1.0f,1.0f,1.0f,1.0f);
//    gl_FragColor = white;
*/

    vec3 V = -normalize(Vertex.xyz);
    vec3 N = normalize(Normal);
    vec3 L = normalize(gl_LightSource[0].position.xyz - Vertex.xyz);
    vec3 R = normalize(reflect(-L,N));//- oder +?


    //diffuse
    float dot_LN = max(0.0,dot(L.xyz,N));

    //specular
    float n = gl_FrontMaterial.shininess;
    float rdotv = max(dot(R,V.xyz),0);
    float dot_rv_n = pow(rdotv,n);

    vec4 kd = gl_FrontMaterial.diffuse;//color diffuse
    vec4 ks = gl_FrontMaterial.specular;//color specular

    vec4 I_L_d = gl_LightSource[0].diffuse;
    vec4 I_L_s = gl_LightSource[0].specular;

    vec4 color = dot_LN*kd*I_L_d + dot_rv_n*ks*I_L_s;

    gl_FragColor = vec4(color);
}

