#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QtGui>
#include <QMenuBar>
#include <QMenu>
#include <QAction>
#include <QKeySequence>
#include <QMessageBox>
#include <QToolBar>
#include <QStatusBar>
#include <myglwidget.h>
#include <QSlider>
#include <QToolButton>
#include <controller.h>
#include <QLayout>
#include <QSplitter>

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    MainWindow(QWidget *parent = 0);
    ~MainWindow();

private:
    QMenuBar *menuBar;

    //Menus
    QMenu *fileMenu;
    QMenu *shadingMenu;

    QMenu *aboutMenu;

    //Tool Bar
    QToolBar *toolBar;

    //Status Bar
    QStatusBar *statusBar;

    //Actions
    QAction *exitAction;

    QAction *aboutAction;

    QAction *shadeWireframeAction;
    QAction *shadeFlatAction;
    QAction *shadeGouraudAction;
    QAction *shadePhongAction;
    QActionGroup *shaderGroup;

    QAction *resetCameraAction;

    QAction *modeCameraAction;
    QAction *modeManipulateAction;
    QActionGroup *modeSwitchGroup;

    QAction *singleViewAction;
    QAction *dualViewAction;
    QAction *quadViewAction;
    QActionGroup *viewGroup;
    QToolButton* viewButton;
    QMenu* viewMenu;

    //Widgets
    MyGLWidget *myGLWidget;
    MyGLWidget *viewFront;
    MyGLWidget *viewLeft;
    MyGLWidget *viewTop;
    QGridLayout *viewLayout;
    QSplitter *viewSplitter1;
    QSplitter *viewSplitter2;
    QSplitter *viewSplitter3;

    //4.1.1 Slider
    QSlider* tesselationSlider;

    Controller* controller;

    QAction* addSphere;
    QAction* addBox;
    QAction* addCylinder;
    QAction* addCone;
    QAction* addTorus;

public slots :
void showAboutBox ( ) ;
};

#endif // MAINWINDOW_H
