#include "mainwindow.h"

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent)
{
    menuBar = new QMenuBar();

    //3.2.1 File Menu
    fileMenu = new QMenu("&File");

    exitAction = new QAction("E&xit",fileMenu);
//  exitAction->setShortcut(QKeySequence::Quit);//original code from assignment. Ctrl+q is not supported on windows.
    exitAction->setShortcut(QKeySequence(tr("Ctrl+Q")));//workaround for windows.
    connect(exitAction , SIGNAL(triggered ( ) ) ,    this , SLOT(close ( ) ) ) ;

    fileMenu->addAction(exitAction );
    menuBar->addMenu(fileMenu );


    //3.2.2 Shading Menu
    shadingMenu = new QMenu("Shading");

    shadeWireframeAction = new QAction("Wireframe",shadingMenu);
    shadeFlatAction = new QAction("Flat",shadingMenu);
    shadeGouraudAction = new QAction("Gouraud",shadingMenu);
    shadePhongAction = new QAction("Phong",shadingMenu);

    shadeWireframeAction->setShortcut(QKeySequence(tr("Ctrl+1")));
    shadeFlatAction->setShortcut(QKeySequence(tr("Ctrl+2")));
    shadeGouraudAction->setShortcut(QKeySequence(tr("Ctrl+3")));
    shadePhongAction->setShortcut(QKeySequence(tr("Ctrl+4")));

    shadeWireframeAction->setCheckable(true);
    shadeFlatAction->setCheckable(true);
    shadeGouraudAction->setCheckable(true);
    shadePhongAction->setCheckable(true);

    shadeWireframeAction->setIcon(QIcon(":/img/wireframe.png"));
    shadeFlatAction->setIcon(QIcon(":/img/flat.png"));
    shadeGouraudAction->setIcon(QIcon(":/img/gouraud.png"));
    shadePhongAction->setIcon(QIcon(":/img/phong.png"));

    shaderGroup = new QActionGroup(shadingMenu);
    shaderGroup->addAction(shadeWireframeAction);
    shaderGroup->addAction(shadeFlatAction);
    shaderGroup->addAction(shadeGouraudAction);
    shaderGroup->addAction(shadePhongAction);

    shadingMenu->addAction(shadeWireframeAction);
    shadingMenu->addAction(shadeFlatAction);
    shadingMenu->addAction(shadeGouraudAction);
    shadingMenu->addAction(shadePhongAction);

    shadeFlatAction->setChecked(true);

    menuBar->addMenu(shadingMenu);

    setMenuBar(menuBar);

    //3.2.3 About Message Box
    aboutAction = new QAction("About",menuBar);
    connect(aboutAction, SIGNAL(triggered()), this,SLOT(showAboutBox()));
    menuBar->addAction(aboutAction);

    //3.3 Toolbar
    toolBar = new QToolBar("ToolBar",this);
    toolBar->addAction(shadeWireframeAction);
    toolBar->addAction(shadeFlatAction);
    toolBar->addAction(shadeGouraudAction);
    toolBar->addAction(shadePhongAction);
    addToolBar( toolBar);

    //3.4 Status Bar
    statusBar = new QStatusBar(this);
    statusBar->showMessage("test status message");
    setStatusBar(statusBar);

    //4.0 Widget //Assignment 2: Multiple Widgets.
    qDebug("widgets...");
    {
    controller = new Controller();
    myGLWidget = new MyGLWidget(0,controller, true, QQuaternion(),this);
    setCentralWidget(myGLWidget);

    viewFront = new MyGLWidget(1,controller, false, QQuaternion(),this);
    viewLeft = new MyGLWidget(2,controller, false, QQuaternion::fromAxisAndAngle(0,1,0,90),this);//TODO check rotations.
    viewTop = new MyGLWidget(3,controller, false, QQuaternion::fromAxisAndAngle(1,0,0,90),this);

    viewSplitter1 = new QSplitter;
    viewSplitter1->addWidget(myGLWidget);
    viewSplitter1->addWidget(viewFront);

    viewSplitter2 = new QSplitter;
    viewSplitter2->addWidget(viewLeft);
    viewSplitter2->addWidget(viewTop);

    viewSplitter3 = new QSplitter;
    viewSplitter3->setOrientation(Qt::Vertical);
    viewSplitter3->addWidget(viewSplitter1);
    viewSplitter3->addWidget(viewSplitter2);

    viewLayout = new QGridLayout(this);
    viewLayout->addWidget(viewSplitter3);

    QWidget* central_widget = new QWidget(this);
    central_widget->setLayout(viewLayout);
    setCentralWidget(central_widget);
}
    qDebug("tesselation...");

    //tesselation slider
    tesselationSlider = new QSlider(Qt::Horizontal,this);
    tesselationSlider->setTickPosition(QSlider::TicksBelow);
    tesselationSlider->setTickInterval(2);
    tesselationSlider->setSizePolicy(QSizePolicy::Fixed,QSizePolicy::Fixed);
    tesselationSlider->setMinimum(1);
    tesselationSlider->setMaximum(16);
    tesselationSlider->setValue(1);
    toolBar->addWidget(tesselationSlider);
    connect(tesselationSlider,SIGNAL(valueChanged(int)),controller,SLOT(setTessellation(int)));

    //4.1.1 connect shading actions to slot
    MyGLWidget* allWidgets[4] = {myGLWidget, viewFront, viewLeft, viewTop};
    for (int i = 0; i < 4; i++){
        connect(shadeWireframeAction,SIGNAL(triggered(bool)),allWidgets[i],SLOT(shadeWireframeSlot()));
        connect(shadeFlatAction,SIGNAL(triggered(bool)),allWidgets[i],SLOT(shadeFlatSlot()));
        connect(shadeGouraudAction,SIGNAL(triggered(bool)),allWidgets[i],SLOT(shadeGouraudSlot()));
        connect(shadePhongAction,SIGNAL(triggered(bool)),allWidgets[i],SLOT(shadePhongSlot()));
    }
    controller->initViewWidgets(allWidgets,viewSplitter1,viewSplitter3,viewLayout);


    //reset Camera button
    resetCameraAction = new QAction("Reset Camera",toolBar);
    resetCameraAction->setIcon(QIcon(":/img/cam_home.png"));
    connect(resetCameraAction,SIGNAL(triggered(bool)),controller,SLOT(resetCamera()));
    toolBar->addAction(resetCameraAction);
    toolBar->insertSeparator(resetCameraAction);


    /* Assignment 2*/
    qDebug("Camera / Object Manipulation...");
    //2 Camera Mode, Object Manipulation Mode
    modeCameraAction = new QAction("Camera Mode",toolBar);
    modeCameraAction->setIcon(QIcon(":/grapa-a2-iconset/camera.png"));
    modeCameraAction->setCheckable(true);
    modeCameraAction->setChecked(true);
    //TODO connect slot
    toolBar->addAction(modeCameraAction);
    toolBar->insertSeparator(modeCameraAction);
    connect(modeCameraAction,SIGNAL(triggered(bool)),controller,SLOT(switchToModeCamera()));

    modeManipulateAction = new QAction("Manipulation Mode", toolBar);
    modeManipulateAction->setIcon(QIcon(":/grapa-a2-iconset/select.png"));
    modeManipulateAction->setCheckable(true);
    //TODO connect slot
    toolBar->addAction(modeManipulateAction);
    connect(modeManipulateAction,SIGNAL(triggered(bool)),controller,SLOT(switchToModeManipulate()));

    controller->initActions(modeCameraAction, modeManipulateAction);

    modeSwitchGroup = new QActionGroup(toolBar);
    modeSwitchGroup->addAction(modeCameraAction);
    modeSwitchGroup->addAction(modeManipulateAction);


    qDebug("View switch...");

    //2 Switch view modes
    viewButton = new QToolButton(toolBar);
    viewButton->setIcon(QIcon(":/grapa-a2-iconset/viewports.png"));
    viewMenu = new QMenu(viewButton);
    viewButton->setMenu(viewMenu);
    viewButton->setPopupMode(QToolButton::MenuButtonPopup);
    toolBar->addWidget(viewButton);
    viewGroup = new QActionGroup(viewMenu);

    singleViewAction = new QAction("Single View",viewMenu);
    singleViewAction->setIcon(QIcon(":/grapa-a2-iconset/view-single.png"));
    singleViewAction->setCheckable(true);
    singleViewAction->setChecked(true);
    singleViewAction->setShortcut(QKeySequence(Qt::Key_1));
    connect(singleViewAction,SIGNAL(triggered(bool)),controller, SLOT(showSingleView()));
    viewMenu->addAction(singleViewAction);
    viewMenu->setDefaultAction(singleViewAction);
    viewGroup->addAction(singleViewAction);

    dualViewAction = new QAction("Dual View",viewMenu);
    dualViewAction->setIcon(QIcon(":/grapa-a2-iconset/view-dual.png"));
    dualViewAction->setCheckable(true);
    dualViewAction->setShortcut(QKeySequence(Qt::Key_2));
    connect(dualViewAction,SIGNAL(triggered(bool)),controller, SLOT(showDoubleView()));
    viewMenu->addAction(dualViewAction);
    viewGroup->addAction(dualViewAction);

    quadViewAction = new QAction("Quad View",viewMenu);
    quadViewAction->setIcon(QIcon(":/grapa-a2-iconset/viewports.png"));
    quadViewAction->setCheckable(true);
    quadViewAction->setShortcut(QKeySequence(Qt::Key_4));
    connect(quadViewAction,SIGNAL(triggered(bool)),controller, SLOT(showQuadView()));
    viewMenu->addAction(quadViewAction);
    viewGroup->addAction(quadViewAction);

    controller->showSingleView();//for whatever reason this works better than setting everything up above. After spending 2 hours setting up the views I honestly don*t care anymore about coding this prettier.

    //Assignment 2: 3) add boxes etc.
{
    addSphere = new QAction("Add Sphere", toolBar);
    addBox = new QAction("Add Box", toolBar);
    addCylinder = new QAction("Add Cylinder", toolBar);
    addCone = new QAction("Add Cone", toolBar);
    addTorus = new QAction("Add Torus", toolBar);

    addSphere->setIcon(QIcon(":/grapa-a2-iconset/sphere.png"));
    addBox->setIcon(QIcon(":/grapa-a2-iconset/box.png"));
    addCylinder->setIcon(QIcon(":/grapa-a2-iconset/cylinder.png"));
    addCone->setIcon(QIcon(":/grapa-a2-iconset/cone.png"));
    addTorus->setIcon(QIcon(":/grapa-a2-iconset/torus.png"));

    addSphere->setCheckable(false);
    addBox->setCheckable(false);
    addCylinder->setCheckable(false);
    addCone->setCheckable(false);
    addTorus->setCheckable(false);

    toolBar->addAction(addSphere);
    toolBar->insertSeparator(addSphere);
    toolBar->addAction(addBox);
    toolBar->addAction(addCylinder);
    toolBar->addAction(addCone);
    toolBar->addAction(addTorus);

    connect(addSphere, SIGNAL(triggered(bool)),controller, SLOT(addSphere()));
    connect(addBox, SIGNAL(triggered(bool)),controller, SLOT(addBox()));
    connect(addCylinder, SIGNAL(triggered(bool)),controller, SLOT(addCylinder()));
    connect(addCone, SIGNAL(triggered(bool)),controller, SLOT(addCone()));
    connect(addTorus, SIGNAL(triggered(bool)),controller, SLOT(addTorus()));
}



    qDebug("Done initializing");


}

MainWindow::~MainWindow()
{

}

//3.2.3 about message box
void MainWindow::showAboutBox(){
    QMessageBox msgBox;
    msgBox.setWindowTitle("About Hello Cube!");
    msgBox.setText("Written by Alisa");
    msgBox.exec();
}
